/****************************************************************************
*  LPC82x RC5 decoder demo program
*
*  1. Use SCT timer to capture and decode RC5 messages.
*  2. Use USART to print received RC5 frames to PC terminal
*****************************************************************************/
#include "global.h"
#include "board.h"
#include "sct_user.h"

void sct_fsm_init(void);

unsigned char RC5_flag;
unsigned char RC5_System;
unsigned char RC5_Command;

void sct_fsm_init(void)
{

	Chip_SCT_Init(LPC_SCT);               								// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, 	SCT_CONFIG_32BIT_COUNTER 	|			// unified timers,
								SCT_CONFIG_AUTOLIMIT_L   	);

	Chip_SCT_SetControl(LPC_SCT , (SystemCoreClock/1000000-1) << 5);	// set prescaler, SCT clock = 1 MHz


	LPC_SCT->REGMODE_L      = (1 << 1) | (1 << 2);        				// register pair 1 and 2 are capture

	Chip_SCT_SetMatchCountL(LPC_SCT, SCT_MATCH_0, match_val);			// match 0 @ 12000/1MHz = 12 msec (timeout)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, match_val);



	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);			// event 0 only happens in state 0

	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH0	|	// MATCHSEL[3:0]   = related to match 0
                                                                        SCT_COMBMODE_MATCH	|	// COMBMODE[13:12] = uses match condition only
                                                                        SCT_STATELD_1		    |	// STATELD [14]    = STATEV is loaded into state
                                                                        SCT_STATEEV_0		    ));	// STATEV  [15]    = new state is 0




	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_STATE0);			// event 1 only happens in state 0

	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH6	|	// IOSEL   [9:6]   = SCT_IN0
                                                                        SCT_IOCOND_FALL	    |	// IOCOND  [11:10] = falling edge
                                                                        SCT_COMBMODE_IO	    |	// COMBMODE[13:12] = uses IO condition only
                                                                        SCT_STATELD_1		    |	// STATELD [14]    = STATEV is loaded into state
                                                                        SCT_STATEEV_0		    ));	// STATEV[ 15]     = new state is 0


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_2,  ENABLE_STATE0);			// event 2 only happens in state 0

	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_2, (CHIP_SCT_EVENTCTRL_T) (  SCT_IOSEL_RISEIN0	|	// IOSEL   [9:6]   = SCT_IN0
                                                                        SCT_IOCOND_RAISE	|	// IOCOND  [11:10] = rising edge
                                                                        SCT_COMBMODE_IO	  |	// COMBMODE[13:12] = uses IO condition only
                                                                        SCT_STATELD_1		  |	// STATELD [14]    = STATEV is loaded into state
                                                                        SCT_STATEEV_0		  ));	// STATEV  [15]    = new state is 0


	Chip_SCT_CapControl(LPC_SCT, SCT_CAPCTRL_1, SCT_EVT_1);				// event 1 causes capture 1 to be loaded
	Chip_SCT_CapControl(LPC_SCT, SCT_CAPCTRL_2, SCT_EVT_2);				// event 2 causes capture 2 to be loaded

	LPC_SCT->LIMIT_L        = 0x0007;                     				// events 0, 1 and 2 are used as counter limit

	Chip_SCT_EnableEventInt(LPC_SCT, (CHIP_SCT_EVENT_T) (SCT_EVT_0 | SCT_EVT_2));			// events 0 and 2 generate interrupts

	NVIC_EnableIRQ(SCT_IRQn);                             				// enable SCT interrupt


	Chip_SCT_ClearControl(LPC_SCT,SCT_CTRL_HALT_L);						// unhalt it by clearing bit 2 of the CTRL register


}




int main (void)
{

	SystemCoreClockUpdate();
	Board_Init();

	Chip_SWM_Init();								/* Configure the switch matrix    */

	Chip_SWM_MovablePinAssign(SWM_SCT_OUT0_O, 12);	/* configure the SWM to output CTOUT_0 to PIO0_12 */


    USART0_Init(19200);
    sct_fsm_init();

    PrintString("\f\nLPC15xx SCT-RC5 test January 2014\n\n");

    while (1)
    {
        if (RC5_flag)                              // wait for RC5 code
        {
            RC5_flag = 0;                          // clear flag
            PrintString("RC5 = ");                 // and print it
            PrintByte(RC5_System);
            PrintString(" ");
            PrintByte(RC5_Command);
            PrintString("\n");
        }
        __WFI();
    }
}
